﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Admin/Ei8htPOS.Master" AutoEventWireup="true" CodeBehind="Quotations.aspx.cs" Inherits="AZVIC.Ei8htPOS.WebUI.Admin.Sales.Quotations.Quotations" %>
<%@ MasterType VirtualPath="~/Admin/Ei8htPOS.Master" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
    <asp:HiddenField ID="hdQuotationID" runat="server" />
    <div class="pageheader">
        <h2>
            <i class="fa fa-quote-left"></i> Quotations
        </h2>
        <div class="breadcrumbs">
            <ol class="breadcrumb">
                <li>You are here</li>
                <li><a href="../Dashboard.aspx">Ei8ht POS</a></li>
                <li class="active">Quotations</li>
            </ol>
        </div>
    </div>

    <div class="main searchFields">
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                Search Word :
            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtSearch" runat="server" CssClass="textbox w100p" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">
                From Date :

            </div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtFromDate" runat="server" CssClass="datepicker" />

            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">To Date :</div>
            <div class="col-md-4 col-xs-12">
                <asp:TextBox ID="txtToDate" runat="server" CssClass="datepicker" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite">Show </div>
            <div class="col-md-4 col-xs-12">
                <asp:CheckBox ID="chkShowPOS" runat="server" Text="Show POS Orders" CssClass="orderfilter" />
                <asp:CheckBox ID="chkShowWeb" runat="server" Text="Show Web Orders" CssClass="orderfilter" />
            </div>
        </div>
        <div class="row padTop10">
            <div class="col-md-2 col-xs-12 tSize18 cwhite"></div>
            <div class="col-md-4 col-xs-12">
                <asp:Button ID="btnSearch" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Search"
                    OnClick="btnSearch_Click" />
                &nbsp;&nbsp;&nbsp;
                        <asp:Button ID="btnShowAll" runat="server" CssClass="btn-lg btn btn-primary loading" Text="Show All"
                            OnClick="btnShowAll_Click" />
            </div>
        </div>
    </div>

    <section class="tile contentField color">
        <div class="tile-header">
            <h1>Quotations</h1><div class="pull-right">
                <asp:Button runat="server" ID="btnExport" OnClick="btnExportToExcel" CssClass="btn-lg btn btn-primary" Text="Export" />
            </div>
        </div>
        <div class="tile-body nopadding">

            <div class="responsive-table">
                <asp:GridView runat="server" ID="grdQuotations" AllowPaging="true" PageSize="30"
                    CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
                    OnPageIndexChanging="grdQuotations_PageIndexChanging" OnRowDataBound="grdQuotations_RowDataBound">
                    <Columns>
                        <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                            HeaderText="Sl. No.">
                            <ItemTemplate>
                                <%# Container.DataItemIndex + 1  %>
                            </ItemTemplate>
                            <HeaderStyle HorizontalAlign="Center" Width="100px"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center"></ItemStyle>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Quote Date" DataField="CreatedDate" DataFormatString="{0:dd/MM/yyyy HH:mm}" />
                        <asp:TemplateField HeaderText="Quotations No.">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:HyperLink ID="linkViewDetails" runat="server" Text='<%# Eval("QuotationsNumber") %>'
                                    NavigateUrl='<%# String.Format("~/Admin/Sales/Quotations/QuotationDetails.aspx?UniqueID={0}", DataBinder.Eval(Container.DataItem,"UniqueID"))%>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="First Name" DataField="FirstName" />
                        <asp:BoundField HeaderText="Last Name" DataField="LastName" />
                        <asp:BoundField HeaderText="Email" DataField="Email" />
                        <asp:BoundField HeaderText="Contact No." DataField="BillingMobile" />
                        <asp:TemplateField HeaderText="Designer Info">
                            <ItemStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkDesignerInfo" runat="server" Text="View" CommandArgument='<%# Eval("UniqueID") %>'
                                    OnClick="lnkDesignerInfo_Click" />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:BoundField HeaderText="Discount" DataField="Discount" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Total Before GST" DataField="TotalBeforeGST" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Total" DataField="Total" DataFormatString="{0:0.00}" />
                        <asp:BoundField HeaderText="Quotation Status" DataField="QuotationsStatus" />
                        <asp:TemplateField HeaderText="Send To Payment">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkSendToPayment" runat="server" Text="Send For Payment" CssClass="loading"
                                    CommandArgument='<%# Eval("UniqueID") %>' OnClick="lnkSendToPayment_Click" Visible='<%# (Eval("QuotationsStatus").ToString().ToLower() == "processed" ? false : true) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Control">
                            <ItemStyle HorizontalAlign="Left" />
                            <ItemTemplate>
                                <asp:LinkButton ID="lnkEditOrder" runat="server" Text="Edit" CommandArgument='<%# Eval("UniqueID") %>'
                                    OnClick="lnkEditOrder_Click" Visible='<%# (Eval("QuotationsStatus").ToString().ToLower() == "processed" ? false : true) %>' />
                                <span visible='<%# (Eval("QuotationsStatus").ToString().ToLower() == "processed" ? false : true) %>'>&nbsp;/&nbsp;</span>
                                <asp:LinkButton ID="lnkHistroy" runat="server" Text="History" CommandArgument='<%# Eval("UniqueID") %>' OnClick="lnkHistroy_Click" />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                        Position="TopAndBottom" />
                    <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                        Font-Bold="true" Font-Size="Medium" />

                    <HeaderStyle CssClass="tbl-header" />
                    <RowStyle CssClass="tbl-row" />
                    <AlternatingRowStyle CssClass="tbl-row" />
                    <EmptyDataRowStyle />
                    <EmptyDataTemplate>
                        No Record found
                    </EmptyDataTemplate>
                    <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                </asp:GridView>
            </div>
        </div>
    </section>
    <div class="row Footercenter">
        <center>All right reserved - www.ei8htpos.com &copy; 2015</center>
    </div>


    <div class="modal fade" id="divPaymentStatus" tabindex="-1" role="dialog" aria-labelledby="Quotation Status" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title" id="H2">Update Quotation Status</h4>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-xs-12 col-md-12">
                            <asp:Label ID="lblEditError" ForeColor="Red" runat="server"></asp:Label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-6">Quotation Status</div>
                        <div class="col-xs-12 col-md-6">
                            <asp:DropDownList ID="ddlQuotationStatus" CssClass="log" runat="server">
                                <asp:ListItem Text="New" Value="New" Selected="True"></asp:ListItem>
                                <asp:ListItem Text="Pending" Value="Pending"></asp:ListItem>
                                <asp:ListItem Text="Processed" Value="Processed"></asp:ListItem>
                                <asp:ListItem Text="Canceled" Value="Canceled"></asp:ListItem>
                            </asp:DropDownList>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <asp:Button ID="btnSave" runat="server" CssClass="btn btn-primary loading" Text="Save"
                            OnClick="btnSave_Click" />
                        &nbsp;
                                <asp:Button ID="btnCancel" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                                    OnClick="btnCancel_Click" />
                    </div>
                </div>
            </div>
        </div>
        </div>



        <div class="modal fade" id="divDesignerInfo" tabindex="-1" role="dialog" aria-labelledby="Designer Info" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H1">Designer Info</h4>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-xs-12 col-md-4">Designer Name</div>
                            <div class="col-xs-12 col-md-6">
                                <asp:TextBox ID="txtDesignerName" runat="server" CssClass="textbox" MaxLength="250" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-12 col-md-4">Remarks</div>
                            <div class="col-xs-12 col-md-6">
                                <asp:TextBox ID="txtDesignerRemarks" runat="server" CssClass="textbox" MaxLength="500" TextMode="MultiLine" />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="btnSaveDesigner" runat="server" CssClass="btn btn-primary loading" Text="Save"
                        OnClick="btnSaveDesigner_Click" />
                    &nbsp;
                                <asp:Button ID="btnCancelDesigner" runat="server" CssClass="btn btn-primary loading" Text="Cancel"
                                    OnClick="btnCancelDesigner_Click" />
                </div>
            </div>
        </div>



        <div class="modal fade" id="divHistory" tabindex="-1" role="dialog" aria-labelledby="History" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" id="H3">Quotation History</h4>
                    </div>
                    <div class="modal-body">
                        <div class="responsive-table">
                            <asp:GridView runat="server" ID="grdHistory" CssClass="table" Width="98%" GridLines="Both" AutoGenerateColumns="false"
                                OnRowDataBound="grdHistory_RowDataBound">
                                <Columns>
                                    <asp:TemplateField HeaderStyle-Width="20" HeaderStyle-HorizontalAlign="Center" ItemStyle-HorizontalAlign="Center"
                                        HeaderText="Sl. No.">
                                        <ItemTemplate>
                                            <%# Container.DataItemIndex + 1  %>
                                        </ItemTemplate>
                                        <HeaderStyle HorizontalAlign="Center" Width="50px"></HeaderStyle>
                                        <ItemStyle HorizontalAlign="Center" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Name">
                                        <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
                                        <ItemTemplate>
                                            <asp:Label runat="server" ID="lblName" Style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="Remarks">
                                        <ItemStyle HorizontalAlign="Left" VerticalAlign="Top" />
                                        <ItemTemplate>
                                            <asp:Label runat="server" ID="lblRemarks" Style="width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;" />
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:BoundField HeaderText="Date" DataField="CreatedDate" DataFormatString="{0:dd/MM/yyyy}" />
                                    <asp:BoundField HeaderText="Time" DataField="CreatedDate" DataFormatString="{0:HH:mm}" />
                                    <asp:BoundField HeaderText="IP Address" DataField="IPAddress" />
                                </Columns>
                                <PagerSettings Mode="NumericFirstLast" Visible="true" NextPageText="" PreviousPageText=""
                                    Position="TopAndBottom" />
                                <PagerStyle CssClass="pg" HorizontalAlign="Right" VerticalAlign="Middle" BorderStyle="None"
                                    BackColor="#ffffff" />
                                <HeaderStyle CssClass="tbl-header" />
                                <RowStyle CssClass="tbl-row" />
                                <AlternatingRowStyle CssClass="tbl-row" />
                                <EmptyDataRowStyle />
                                <EmptyDataTemplate>
                                    No Record found
                                </EmptyDataTemplate>
                                <EmptyDataRowStyle VerticalAlign="Middle" HorizontalAlign="Center" />
                            </asp:GridView>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <asp:Button ID="btnClose" runat="server" CssClass="btn btn-primary loading" Text="Close" />
                    </div>
                </div>
            </div>
        </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="ScriptContent" runat="server">
</asp:Content>
